# AR Operator Core

This package implements the core tick‑flip operator algebra (F, S, X, C, Φ) used in the
Absolute Relativity framework.  It provides a simple dataclass `TickState` to hold the
context distribution and a suite of operators to evolve that distribution.

## Contents

* **Operators**
  * `F` – renewal (outward flip)
  * `S` – sinking (inward flip)
  * `X` – distinction / trade (reflection)
  * `C` – sync (symmetric projection)
  * `Φ` – frame coupling (`C ∘ X`)
* **State**
  * `TickState` – dataclass storing the 1D distribution array and context depth `N`
* **Utilities**
  * `load_boundary_graph(path)` / `validate_graph(graph)` – load and validate
    adjacency matrices of boundary graphs

This copy of the repository has been pared down for integration testing as part
of the Volume 4 pipeline.  For full documentation, examples and licensing
information, please refer to the original GitHub repository.

## Integration in the Volume 4 workflow

When the ``ar-operator-core`` repository lives alongside the
``vol4-flip-count-simulator`` and ``vol4-discrete-gauge-wilson-loop``
repositories it is automatically discoverable by the simulator via the
``scripts/generate_flip_counts.py`` path adjustment.  You do not need to
install this package with pip or conda in the integrated workspace; the
generator script temporarily adds the ``ar-operator-core`` directory to
``sys.path``.  To run the entire pipeline in one step use the top‑level
``bootstrap_and_run.sh`` script provided in the integrated workspace.
